<?php
namespace Aura\Html\Helper;

/**
 * Test class for Title.
 * Generated by PHPUnit on 2011-04-02 at 08:29:14.
 */
class TitleTest extends AbstractHelperTest
{
    public function test__invoke()
    {
        $title = $this->helper;
        $actual = $title();
        $this->assertInstanceOf('Aura\Html\Helper\Title', $actual);

        $expect = '    <title>Foo &amp; Bar</title>' . PHP_EOL;
        $actual = $title('Foo & Bar')->__toString();
        $this->assertSame($expect, $actual);
    }

    public function testEscaped()
    {
        $title = $this->helper;
        $this->assertInstanceOf('Aura\Html\Helper\Title', $title);

        $data = (object) array(
            'main' => 'This & That',
            'suf1' => ' > Suf1',
            'suf2' => ' > Suf2',
            'pre1' => 'Pre1 > ',
            'pre2' => 'Pre2 > ',
        );

        $title->set($data->main);

        $title->append($data->suf1);
        $title->append($data->suf2);

        $title->prepend($data->pre1);
        $title->prepend($data->pre2);

        $actual = $title->__toString();
        $expect = '    <title>Pre2 &gt; Pre1 &gt; This &amp; That &gt; Suf1 &gt; Suf2</title>' . PHP_EOL;
        $this->assertSame($expect, $actual);
    }

    public function testRaw()
    {
        $title = $this->helper;
        $this->assertInstanceOf('Aura\Html\Helper\Title', $title);

        $data = (object) array(
            'main' => 'This & That',
            'suf1' => ' > Suf1',
            'suf2' => ' > Suf2',
            'pre1' => 'Pre1 > ',
            'pre2' => 'Pre2 > ',
        );

        $title->setRaw($data->main);

        $title->appendRaw($data->suf1);
        $title->appendRaw($data->suf2);

        $title->prependRaw($data->pre1);
        $title->prependRaw($data->pre2);

        $actual = $title->__toString();
        $expect = '    <title>Pre2 > Pre1 > This & That > Suf1 > Suf2</title>' . PHP_EOL;
        $this->assertSame($expect, $actual);
    }
    public function testSetIndent()
    {
        $title = $this->helper;
        $title->setIndent('  ');
        $data = (object) array(
            'main' => 'This and That',
        );
        $title->set($data->main);
        $actual = $title->__toString();
        $expect = '  <title>This and That</title>' . PHP_EOL;
        $this->assertSame($expect, $actual);
    }
}
